\\\\\\ Audit Stock Summary with GL posting
\\ Sales
select v.comp_id, v.year_id, v.voucher_id, v.cr_amt, d2.credit
from (select comp_id, year_id, voucher_id, sum(cr_amt) cr_amt from v_stk where cr_amt<>0 and substr(voucher_id,1,2)='SL' group by comp_id, year_id, voucher_id) v
left join (select comp_id, year_id, voucher_id, credit from voucherdet where acct_id='2210000001' and credit<>0) d2 on v.comp_id=d2.comp_id and v.year_id=d2.year_id and v.voucher_id=d2.voucher_id
where v.cr_amt<>0 and d2.voucher_id is null
order by v.voucher_id

select v.comp_id, v.year_id, v.voucher_id, v.db_amt, d2.debit
from (select comp_id, year_id, voucher_id, sum(db_amt) db_amt from v_stk where db_amt<>0 and substr(voucher_id,1,2)='PL' group by comp_id, year_id, voucher_id) v
left join (select comp_id, year_id, voucher_id, debit from voucherdet where acct_id='2210000001' and debit<>0) d2 on v.comp_id=d2.comp_id and v.year_id=d2.year_id and v.voucher_id=d2.voucher_id
where v.db_amt<>0 and d2.voucher_id is null
order by v.voucher_id

select v.comp_id, v.year_id, v.voucher_id, v.db_amt, d2.debit
from (select comp_id, year_id, voucher_id, sum(db_amt) db_amt from v_stk where db_amt<>0 group by comp_id, year_id, voucher_id) v
left join (select comp_id, year_id, voucher_id, debit from voucherdet where acct_id='2210000001' and debit is not null) d2 on v.comp_id=d2.comp_id and v.year_id=d2.year_id and v.voucher_id=d2.voucher_id
where v.db_amt<>0 and d2.voucher_id is null
order by v.voucher_id

select v.comp_id, v.year_id, v.voucher_id, v.db_amt, d2.debit
from (select comp_id, year_id, voucher_id, sum(db_amt) db_amt from v_stk where db_amt is not null group by comp_id, year_id, voucher_id) v
left join (select comp_id, year_id, voucher_id, debit from voucherdet where acct_id='2210000001' and debit is not null) d2 on v.comp_id=d2.comp_id and v.year_id=d2.year_id and v.voucher_id=d2.voucher_id
where  (db_amt-debit)>1
order by v.voucher_id

\\\\\\\\\\\\ Imported items sold
select v.*
from v_p_vouchers v
left join item i on v.stock_code=i.stock_code
where i.cat_id='02'
and substr(v.voucher_id,1,2)<>'PL'
\\\\\\\\\\\\ Duplicate Items

select comp_id, year_id, voucher_id, count(*)
from sl_invoice
group by comp_id, year_id, voucher_id
having count(*)>1

select comp_id, year_id, voucher_id, lineitem, count(*)
from sl_invoicedet
group by comp_id, year_id, voucher_id, lineitem
having count(*)>1


\\\ Duplicate Imported Items not sold
select i.stock_code, i.description, i.cat_id, d.vouchers
FROM
item i
left join (select stock_code, count(*) vouchers from v_p_vouchers where substr(voucher_id,1,2)='SL' group by stock_code) d on i.stock_code=d.stock_code
where i.cat_id='02' and d.stock_code is null and i.description in(
select description
FROM
(
select description, count(*)
from item
group by description
having count(*)>1
) v
) 
order by description

\\\
select i.*
FROM
item i
left join v_p_vouchers d on i.stock_code=d.stock_code
where d.stock_code is null and description in(
select description
FROM
(
select description, count(*)
from item
group by description
having count(*)>1
) v
) 
order by description

\\\\\\\\\\\\ Check Sale Return Vouchers
SELECT  m.comp_id,
                                    m.year_id,
									m.voucher_id,
									m.voucher_date,
									m.acct_id,
									p.acct_name,
									m.adv_amt,
									m.net_amt,
									m.disc_amt,
									d.avg_rate
FROM sl_return m 
LEFT JOIN (select comp_id, year_id, voucher_id, sum(qty*avg_rate) avg_rate from sl_returndet group by comp_id, year_id, voucher_id) d ON m.voucher_id = d.voucher_id AND m.comp_id = d.comp_id AND m.year_id = d.year_id
LEFT JOIN v_party p ON m.acct_id = p.acct_id
WHERE  1 = 1 and m.voucher_id='RT090005' 
ORDER BY m.comp_id, m.year_id, m.voucher_id;

select * from voucherdet where voucher_id='RTRT090005' and comp_id='02'


\\\\\\\\\\\\ Un-Balance Sale Invoice voucher
select v.comp_id,
       v.year_id,
       v.voucher_id,
       v.voucher_date,
	  vd.itemtot,
       v.disc_amt,
       v.dc_amt,
       v.net_amt,
	 (ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0)+ifnull(v.dc_amt,0))-v.net_amt diff
from sl_invoice v
left join (select comp_id, year_id, voucher_id, sum(itemtot) itemtot from sl_invoicedet group by comp_id, year_id, voucher_id) vd on v.comp_id=vd.comp_id and v.year_id=vd.year_id and v.voucher_id=vd.voucher_id
where ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0)+ifnull(v.dc_amt,0)<>v.net_amt
order by v.comp_id,v.year_id, v.voucher_id

\\\\\\\\\\\\ Un-Balance Purchase Invoice voucher
select v.comp_id,
       v.year_id,
       v.voucher_id,
       v.voucher_date,
			 vd.itemtot,
       v.disc_amt,
       v.dc_amt,
       v.net_amt,
			 (ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0)+ifnull(v.dc_amt,0))-v.net_amt diff
from pl_invoice v
left join (select comp_id, year_id, voucher_id, sum(itemtot) itemtot from pl_invoicedet group by comp_id, year_id, voucher_id) vd on v.comp_id=vd.comp_id and v.year_id=vd.year_id and v.voucher_id=vd.voucher_id
where ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0)+ifnull(v.dc_amt,0)<>v.net_amt
order by v.comp_id,v.year_id, v.voucher_id

\\\\\\\\\\\\ Averate Rate for Purchase Cost 
SELECT sum(ifnull(d.db_amt,0)-ifnull(d.cr_amt,0))/sum(ifnull(d.db_qty,0)-ifnull(d.cr_qty,0)) total
	 	        from v_p_vouchers d
                where d.voucher_date<='2017-08-04' and d.stock_code='3976';

SELECT avg(d.rate) total
	 	  from pl_invoice v
  		left join pl_invoicedet d on v.comp_id = d.comp_id and v.year_id = d.year_id and v.voucher_id=d.voucher_id
        	where ifnull(v.bill_date,v.voucher_date)<='2017-09-15' and d.stock_code='3976'

SELECT v.voucher_date, d.rate total
	 	  from pl_invoice v
  		left join pl_invoicedet d on v.comp_id = d.comp_id and v.year_id = d.year_id and v.voucher_id=d.voucher_id
        	where ifnull(v.bill_date,v.voucher_date)<='2017-08-04' and d.stock_code='3976'
            order by 1

\\\\\\\\\\\\ Profit & Loss
SELECT ALL n.acct_name acct_name, SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0)) amt 
FROM v_vouchers v 
LEFT JOIN nom n ON (v.acct_id=n.acct_id) 
LEFT JOIN acct_type t ON (n.acct_type=t.acct_id) 
LEFT JOIN company c ON (c.comp_id=v.comp_id) 
WHERE 1 = 1 
and (v.voucher_date BETWEEN '2017-08-01' AND '2017-09-12') and v.comp_id = '02' 
AND SUBSTR(t.acct_id,1,1)='4' 
GROUP BY n.acct_name HAVING SUM(IFNULL(v.credit,0)-IFNULL(v.debit,0))<>0 
ORDER BY 1

\\\\\\\\\\\\ Un-Balance Trial
select v.comp_id, v.year_id, v.VOUCHER_ID, v.debit, v.credit
FROM
(
select vd.comp_id,
       vd.year_id,
       vd.voucher_id,
       sum(vd.debit) debit,
       sum(vd.credit) credit
from voucher v
left join voucherdet vd on v.voucher_id=vd.voucher_id
left join nom n on vd.acct_id=n.acct_id
GROUP BY vd.comp_id, vd.year_id, vd.voucher_id
) v
where v.debit<>v.credit

\\\\\\\\\\\\ Group stock for
SELECT COUNT('chasis_no') units 
FROM 
(
SELECT s.chasis_no from stock s WHERE s.V_PREFIX = 'GRN' and s.TO_COMP_ID = 'TH'
union all 
SELECT s.chasis_no from stock s 
LEFT JOIN sl_shipdet_for f on s.chasis_no=f.chasis_no and s.to_comp_id=f.comp_id
WHERE s.V_PREFIX = 'GRN' and f.chasis_no is not null 
) v;

SELECT COUNT('chasis_no') units 
FROM stock s 
LEFT JOIN sl_shipdet_for f on s.chasis_no=f.chasis_no and s.to_comp_id=f.comp_id
WHERE s.V_PREFIX = 'GRN' and (s.TO_COMP_ID = 'TH' or f.chasis_no is not null)

\\\\\\\\\\\\ Query Purchase Voucher
select m.voucher_id, m.voucher_date, d.* 
from pl_invoice m
left join pl_invoicedet d on concat(m.comp_id,m.year_id,m.voucher_id)= concat(d.comp_id,d.year_id,d.voucher_id) 
where d.stock_code='3826' and m.voucher_date<'2017-08-01'
order by m.voucher_date

\\\\\\\\\\\\ Query Sale Voucher
select m.voucher_id, m.voucher_date, d.* 
from sl_invoice m
left join sl_invoicedet d on concat(m.comp_id,m.year_id,m.voucher_id)= concat(d.comp_id,d.year_id,d.voucher_id) 
where d.stock_code='3826' and m.voucher_date<'2017-08-01'
order by m.voucher_date

\\\\\\\\\\\\ Un-Balance Sale Net_Amt
select v.comp_id, v.year_id, v.voucher_id, v.net_amt, v.disc_amt, vd.itemtot 
from sl_invoice v
left join (select comp_id, year_id, voucher_id, sum(itemtot) itemtot from sl_invoicedet group by comp_id, year_id, voucher_id) vd on v.comp_id=vd.comp_id and v.year_id=vd.year_id and v.voucher_id=vd.voucher_id
where v.net_amt<>(ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0))

\\\\\\\\\\\\ Un-Balance Purchase Net_Amt
select v.comp_id, v.year_id, v.voucher_id, v.net_amt, v.disc_amt, vd.itemtot 
from pl_invoice v
left join (select comp_id, year_id, voucher_id, sum(itemtot) itemtot from pl_invoicedet group by comp_id, year_id, voucher_id) vd on v.comp_id=vd.comp_id and v.year_id=vd.year_id and v.voucher_id=vd.voucher_id
where v.net_amt<>(ifnull(vd.itemtot,0)-ifnull(v.disc_amt,0))

\\\\\\\\\\\\
SELECT emp_id FROM cnlxidtp_click_bk.pl_invoice;
SELECT emp_id FROM cnlxidtp_click_kt.pl_invoice;
SELECT emp_id FROM cnlxidtp_click_madni.pl_invoice;

\\\
select * from voucher where voucher_id='PL060010'
select * from voucherdet where voucher_id='PL060010'

\\\\\\\\\\\\ Check Vouchers
select * from sl_invoice where concat(comp_id,year_id,voucher_id)='KT17080002';

\\\\\\\\\\\\ Orphin acct_id
select vd.acct_id
from voucherdet vd
left join nom n on vd.acct_id=n.acct_id 
where n.acct_id is null 

select vd.year_id
from voucher vd
left join fin_years n on vd.year_id=n.year_id 
where n.year_id is null 

\\\\\\\\\\\\ Sum Voucher
select vd.comp_id,
       vd.year_id,
       vd.voucher_id,
       sum(vd.debit) debit,
       sum(vd.credit) credit
from voucher v
left join voucherdet vd on v.voucher_id=vd.voucher_id
left join nom n on vd.acct_id=n.acct_id
where v.voucher_id='JV070001'
GROUP BY vd.comp_id, vd.year_id, vd.voucher_id
\\\\\\\\\\\\ Un Balance T
select 'KT','17','00001',lpad(@ser := @ser +1,3,'0'), n.stock_code, x.qty, x.rate, x.amount
from xls_stk_bal x
left join item n on x.description=n.description;

\\\\\\\\\\\\ Un Balance Trial
select v.comp_id, v.year_id, v.VOUCHER_ID, v.debit, v.credit
FROM
(
select vd.comp_id,
       vd.year_id,
       vd.voucher_id,
       sum(vd.debit) debit,
       sum(vd.credit) credit
from voucher v
left join voucherdet vd on v.voucher_id=vd.voucher_id
left join nom n on vd.acct_id=n.acct_id
GROUP BY vd.comp_id, vd.year_id, vd.voucher_id
) v
where v.debit<>v.credit
\\\\\\\\\\\\
SELECT * FROM `sl_invoicedet` WHERE rate<> itemtot/qty

select comp_id, year_id, count(*) from pl_invoice;
select comp_id, year_id, count(*) from pl_invoicedet;

SELECT * FROM `pl_invoice`  
where voucher_id='070027' and comp_id='02'

select sum(debit), sum(credit)
from voucherdet
where voucher_id='JV070001' and comp_id='KT'

\\\\\\\\\\\\
select d.stock_code
from sl_invoicedet d
left join item i on d.stock_code=i.stock_code
where i.stock_code is null

\\\\\\\\\\\\\\\\\\\\ v_vouchers
SELECT

	`v`.`COMP_ID` AS `comp_id`
FROM `voucher` `v`
LEFT JOIN `voucherdet` `vd` ON
								`v`.`COMP_ID` = `vd`.`COMP_ID`
							AND 
								`v`.`YEAR_ID` = `vd`.`YEAR_ID`
							AND 
								`v`.`VOUCHER_ID` = `vd`.`VOUCHER_ID`

LEFT JOIN `v_voucherdet_pay` `d` ON 
								`vd`.`COMP_ID` = `d`.`COMP_ID`
							AND 
								`vd`.`YEAR_ID` = `d`.`YEAR_ID`
							AND 
								`vd`.`VOUCHER_ID` = `d`.`VOUCHER_ID`

LEFT JOIN `nom` `n` ON `vd`.`ACCT_ID` = `n`.`ACCT_ID`


\\\\\\\\\\\\\\\\\\\\
select * from pl_invoicedet_copy where concat(comp_id,voucher_id) not in(select concat(comp_id,voucher_id) from pl_invoice);


\\\\\\\\\\\\\\\\
SELECT * FROM `voucherdet` WHERE debit is not null and credit is not null;

SELECT * FROM `voucherdet` WHERE debit is not null and credit is not null and substring(voucher_id,1,2)='CR' and substring(lineitem,-1)='.'
\\\\\\\\\\\\\\\\\\\
SELECT * FROM `v_vouchers` WHERE voucher_id='02CP060001/1.'
\\\\\\\\\\\\\
select distinct t.rn, t1.particulars receipt, t1.amount debit_amount, t2.particulars payment, t2.amount credit_amount FROM ( select * FROM (SELECT @rn1:=@rn1+1 AS rn, v.comp_id, v.voucher_id, v.voucher_date, v.acct_id, debit amount, v.lineitem, v.particulars, v.acct_name FROM v_vouchers v WHERE 1 = 1 AND v.acct_id = '2710000001' AND (v.voucher_date = '2017-06-08') AND v.comp_id = '02' and debit<>0 ) t1, (SELECT @rn1:=0) t2 union all select * FROM (SELECT @rn2:=@rn2+1 AS rn, v.comp_id, v.voucher_id, v.voucher_date, v.acct_id, credit amount, v.lineitem, v.particulars, v.acct_name FROM v_vouchers v WHERE 1 = 1 AND v.acct_id = '2710000001' AND (v.voucher_date = '2017-06-08') AND v.comp_id = '02' and credit<>0 ) t1, (SELECT @rn2:=0) t2 ) t left join (select * FROM (SELECT @rn3:=@rn3+1 AS rn, v.comp_id, v.voucher_id, v.voucher_date, v.acct_id, debit amount, v.lineitem, v.particulars, v.acct_name FROM v_vouchers v WHERE 1 = 1 AND v.acct_id = '2710000001' AND (v.voucher_date = '2017-06-08') AND v.comp_id = '02' and debit<>0 ) t1, (SELECT @rn3:=0) t2) t1 on t.rn=t1.rn left join (select * FROM (SELECT @rn4:=@rn4+1 AS rn, v.comp_id, v.voucher_id, v.voucher_date, v.acct_id, credit amount, v.lineitem, v.particulars, v.acct_name FROM v_vouchers v WHERE 1 = 1 AND v.acct_id = '2710000001' AND (v.voucher_date = '2017-06-08') AND v.comp_id = '02' and credit<>0 ) t1, (SELECT @rn4:=0) t2) t2 on t.rn=t2.rn


\\\\\\\\\\
select * from voucher where voucher_date<'2017-06-01' and comp_id='02';
select * from voucherdet where concat(comp_id,voucher_id) in(select  concat(comp_id,voucher_id) from voucher where voucher_date<'2017-06-01' and comp_id='02');
select distinct substring(voucher_id,1,2) from voucher where voucher_date<'2017-06-01' and comp_id='02';

\\\\\
select * from voucherdet where substring(voucher_id,1,2)='CP' and acct_id='2710000001' and debit>0 and comp_id='02';


\\\\\\\\\\\\\\\
select distinct t.rn, t1.particulars, t1.amount db_amt, t2.particulars, t2.amount cr_amt
FROM
(
select *
FROM
(SELECT @rn1:=@rn1+1 AS rn, 
	v.comp_id,
	v.voucher_id,
	v.voucher_date,
	v.acct_id,
	debit amount,
	v.lineitem,
	v.particulars,
	v.acct_name
FROM
	v_vouchers v
WHERE
	1 = 1
AND v.acct_id = '2710000005'
AND v.acct_id = '2710000005'
AND (
	v.voucher_date BETWEEN '2017-06-08'
	AND '2017-06-10'
)
AND v.comp_id = '02'
and debit<>0
ORDER BY
	v.acct_name,
	v.voucher_date,
	v.voucher_id,
	v.lineitem
) t1, (SELECT @rn1:=0) t2

union all

select *
FROM
(SELECT @rn2:=@rn2+1 AS rn, 
	v.comp_id,
	v.voucher_id,
	v.voucher_date,
	v.acct_id,
	credit amount,
	v.lineitem,
	v.particulars,
	v.acct_name
FROM
	v_vouchers v
WHERE
	1 = 1
AND v.acct_id = '2710000005'
AND v.acct_id = '2710000005'
AND (
	v.voucher_date BETWEEN '2017-06-08'
	AND '2017-06-10'
)
AND v.comp_id = '02'
and credit<>0
ORDER BY
	v.acct_name,
	v.voucher_date,
	v.voucher_id,
	v.lineitem
) t1, (SELECT @rn2:=0) t2


) t

left join (select *
FROM
(SELECT @rn3:=@rn3+1 AS rn, 
	v.comp_id,
	v.voucher_id,
	v.voucher_date,
	v.acct_id,
	debit amount,
	v.lineitem,
	v.particulars,
	v.acct_name
FROM
	v_vouchers v
WHERE
	1 = 1
AND v.acct_id = '2710000005'
AND v.acct_id = '2710000005'
AND (
	v.voucher_date BETWEEN '2017-06-08'
	AND '2017-06-10'
)
AND v.comp_id = '02'
and debit<>0
ORDER BY
	v.acct_name,
	v.voucher_date,
	v.voucher_id,
	v.lineitem
) t1, (SELECT @rn3:=0) t2) t1 on t.rn=t1.rn

left join (select *
FROM
(SELECT @rn4:=@rn4+1 AS rn, 
	v.comp_id,
	v.voucher_id,
	v.voucher_date,
	v.acct_id,
	credit amount,
	v.lineitem,
	v.particulars,
	v.acct_name
FROM
	v_vouchers v
WHERE
	1 = 1
AND v.acct_id = '2710000005'
AND v.acct_id = '2710000005'
AND (
	v.voucher_date BETWEEN '2017-06-08'
	AND '2017-06-10'
)
AND v.comp_id = '02'
and credit<>0
ORDER BY
	v.acct_name,
	v.voucher_date,
	v.voucher_id,
	v.lineitem
) t1, (SELECT @rn4:=0) t2) t2 on t.rn=t2.rn
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
SELECT acct_id, acct_name FROM `party` WHERE gl_acct_id is null  and substring(acct_id,1,1)='C'
\\\\\\\\\\
select voucher_date, sum(net_amt) from sl_invoice group by voucher_date;

SELECT
	if(DAYOFWEEK (voucher_date)=1,sum(net_amt),0) amt_01,
	if(DAYOFWEEK (voucher_date)=2,sum(net_amt),0) amt_02,
	if(DAYOFWEEK (voucher_date)=3,sum(net_amt),0) amt_03,
	if(DAYOFWEEK (voucher_date)=4,sum(net_amt),0) amt_04,
	if(DAYOFWEEK (voucher_date)=5,sum(net_amt),0) amt_05,
	if(DAYOFWEEK (voucher_date)=6,sum(net_amt),0) amt_06,
	if(DAYOFWEEK (voucher_date)=7,sum(net_amt),0) amt_07
FROM
	sl_invoice
WHERE 1 = 1
	AND voucher_date BETWEEN adddate(curdate(), INTERVAL 1-DAYOFWEEK(curdate()) DAY) AND CURDATE()

\\\\\\\\\\\\\\\\
select code, agent_id, count(*)
from company_code
group by code, agent_id
having count(*)>1
order by 3 desc
\\\\\\\\\\\\\
delete from party;

insert into party(acct_id, acct_name)
select code, `name`
FROM
(
select code, agent_id, name, count(*)
from click_mli.company_code
group by code, agent_id, name
having count(*)>1
order by 3 desc
) v;
